﻿using System;
using System.Activities;
using System.Linq;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Workflow;
using VA.PPMS.Context;

namespace VA.PPMS.Workflows.Provider
{
    public sealed class HistoryLogLastCreatedUpdate : CodeActivity
    {
        protected override void Execute(CodeActivityContext executionContext)
        {
            //Create the tracing service
            ITracingService tracingService = executionContext.GetExtension<ITracingService>();

            //Create the context
            IWorkflowContext context = executionContext.GetExtension<IWorkflowContext>();
            IOrganizationServiceFactory serviceFactory = executionContext.GetExtension<IOrganizationServiceFactory>();
            IOrganizationService service = serviceFactory.CreateOrganizationService(context.UserId);

            tracingService.Trace("Update Last History Log");

            //Get the Provider Entity Reference and History Log Type Inputs. 
            EntityReference provider = this.RelatedProvider.Get(executionContext);
            EntityReference historyLog = this.HistoryLog.Get(executionContext);
            OptionSetValue historyLogType = this.HistoryLogType.Get(executionContext);
            if (provider != null && historyLog != null && historyLogType != null)
            {
                tracingService.Trace("Looking up the Last History Log for given attribute type");
                //Find the last created History Log here based on the type. 
                using (var svc = new PpmsContext(service))
                {
                    ppms_historylog lastHistoryLog = null;
                    //If this is a CCN status update, we need to also check the Network. 
                    if (historyLogType.Value == (int)ppms_historylog_ppms_type.CCNStatus)
                    {                       
                        var thisHistoryLog = svc.ppms_historylogSet.First(i => i.Id == historyLog.Id);
                        //Chagne this to NetworkID lookup? 
                        //var network = thisHistoryLog.ppms_Network;
                        var networkId = thisHistoryLog.ppms_NetworkId;

                        lastHistoryLog = svc.ppms_historylogSet
                       .Where(h => h.Id != historyLog.Id &&
                                   h.ppms_providerid == provider &&
                                   h.ppms_type == historyLogType &&
                                   h.ppms_NetworkId == networkId)
                       .OrderByDescending(h => h.CreatedOn)
                       .FirstOrDefault();
                    }
                    //If not a CCN status update we just have to check the History Log Type. 
                    else
                    {
                        lastHistoryLog = svc.ppms_historylogSet
                            .Where(h => h.Id != historyLog.Id &&
                                        h.ppms_providerid == provider &&
                                        h.ppms_type == historyLogType)
                            .OrderByDescending(h => h.CreatedOn)
                            .FirstOrDefault();
                    }

                    if(lastHistoryLog != null)
                    {
                        tracingService.Trace("Found the Last History Log for given attribute type");
                        var updateLastHistoryLog = new ppms_historylog {};
                        updateLastHistoryLog.Id = lastHistoryLog.Id;
                        updateLastHistoryLog.ppms_statusenddate = DateTime.UtcNow;
                        service.Update(updateLastHistoryLog);
                        tracingService.Trace("Last History Log Updated with Status End Date");
                    }
                    
                }
            }
        }

        [AttributeTarget("ppms_historylog", "ppms_type")]
        [Input("History Log Type")]
        public InArgument<OptionSetValue> HistoryLogType { get; set; }

        [ReferenceTarget("account")]
        [Input("Related Provider")]
        public InArgument<EntityReference> RelatedProvider { get; set; }

        [ReferenceTarget("ppms_historylog")]
        [Input("History Log")]
        public InArgument<EntityReference> HistoryLog { get; set; }
    }
}
